/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseFComplexMatrix1D(int n, ConcurrentHashMap<Long, float[]> concurrentHashMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected SelectedSparseFComplexMatrix1D(ConcurrentHashMap<Long, float[]> concurrentHashMap, int[] nArray) {
        this(nArray.length, concurrentHashMap, 0, 1, nArray, 0);
    }

    @Override
    protected int _offset(int n) {
        return this.offsets[n];
    }

    @Override
    public float[] getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D instanceof SelectedSparseFComplexMatrix1D) {
            SelectedSparseFComplexMatrix1D selectedSparseFComplexMatrix1D = (SelectedSparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == selectedSparseFComplexMatrix1D.elements;
        }
        if (fComplexMatrix1D instanceof SparseFComplexMatrix1D) {
            SparseFComplexMatrix1D sparseFComplexMatrix1D = (SparseFComplexMatrix1D)fComplexMatrix1D;
            return this.elements == sparseFComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    @Override
    public FComplexMatrix1D like(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        return new SparseFComplexMatrix2D(n, n2);
    }

    @Override
    public FComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public void setQuick(int n, float[] fArray) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public void setQuick(int n, float f, float f2) {
        long l = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseFComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FloatMatrix1D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

