/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.information.DynamicMapping;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.modelling.Residuals;
import lombok.Generated;

public final class ResidualsExtractors {
    @Generated
    private ResidualsExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Dynamic
    extends DynamicMapping<Residuals, StatisticalTest> {
        public Dynamic() {
            super(null, v -> v.getTests());
        }

        public Class<Residuals> getSourceClass() {
            return Residuals.class;
        }

        public int getPriority() {
            return 0;
        }
    }

    public static class Specific
    extends InformationMapping<Residuals> {
        public Specific() {
            this.set("type", String.class, source -> source.getType().name());
            this.set("res", double[].class, source -> source.getRes().toArray());
            this.set("tsres", TsData.class, source -> {
                TsPeriod start = source.getStart();
                if (start == null) {
                    return null;
                }
                return TsData.of((TsPeriod)start, (DoubleSeq)source.getRes());
            });
            this.set("ser", Double.class, source -> source.getSer());
            this.addTest("mean");
            this.addTest("doornikhansen");
            this.addTest("skewness");
            this.addTest("kurtosis");
            this.addTest("lb");
            this.addTest("bp");
            this.addTest("seaslb");
            this.addTest("seasbp");
            this.addTest("lb2");
            this.addTest("bp2");
            this.addTest("nruns");
            this.addTest("lruns");
            this.addTest("nudruns");
            this.addTest("ludruns");
        }

        private void addTest(String k) {
            this.set(k, StatisticalTest.class, source -> source.getTests().get(k));
        }

        public Class<Residuals> getSourceClass() {
            return Residuals.class;
        }

        public int getPriority() {
            return 1;
        }
    }
}

