## -----------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(dcmstan)

## -----------------------------------------------------------------------------
library(dcmdata)

dtmr_qmatrix

## -----------------------------------------------------------------------------
spec <- dcm_specify(
  qmatrix = dtmr_qmatrix,
  identifier = "item",
  measurement_model = dina(),
  structural_model = bayesnet()
)

spec

## -----------------------------------------------------------------------------
stan_code(spec)

## -----------------------------------------------------------------------------
dtmr_data

dat <- stan_data(spec, data = dtmr_data, identifier = "id")
str(dat)

