/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.cmd;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import usf.saav.cmd.MergePairingInput;
import usf.saav.cmd.PairingResult;
import usf.saav.cmd.ResultList;
import usf.saav.common.Timer;
import usf.saav.common.TimerMillisecond;
import usf.saav.common.TimerNanosecond;
import usf.saav.topology.TopoTreeNode;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphLoader;
import usf.saav.topology.reebgraph.ReebGraphVertex;
import usf.saav.topology.reebgraph.pairing.MergePairing;
import usf.saav.topology.reebgraph.pairing.Pairing;
import usf.saav.topology.reebgraph.pairing.PropagateAndPair;

public class TestResults {
    int loops;
    int initial_verts;
    int conditioned_verts;
    Timer mergeTimer = new TimerNanosecond();
    Timer ppTimer = new TimerNanosecond();
    ArrayList<ReebGraph> rgMP;
    ArrayList<ReebGraph> rgPP;
    int timeElapsedMergePairing;

    private TestResults() {
    }

    public static TestResults testPerformance(String string, boolean bl) throws Exception {
        TestResults testResults = new TestResults();
        testResults.initial_verts = ReebGraphLoader.load(string, false, false, bl).get(0).size();
        testResults.rgMP = TestResults.runAlgo(string, new MergePairing(), testResults.mergeTimer, bl);
        testResults.rgPP = TestResults.runAlgo(string, new PropagateAndPair(), testResults.ppTimer, bl);
        testResults.conditioned_verts = 0;
        for (ReebGraph reebGraph : testResults.rgMP) {
            testResults.conditioned_verts += reebGraph.size();
        }
        testResults.loops = TestResults.countLoops(testResults.rgMP);
        if (bl) {
            System.out.println("\nCOMPARING GRAPHS");
        }
        if (!TestResults.compareDiagrams(testResults.rgMP, testResults.rgPP, bl)) {
            if (bl) {
                System.out.println("ERROR: Difference Found in pairings");
            }
            return null;
        }
        if (bl) {
            System.out.println();
        }
        return testResults;
    }

    public static void savePersistentDiagram(ArrayList<ReebGraph> arrayList, String string) throws FileNotFoundException {
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList2.addAll(object);
        }
        PrintWriter printWriter = new PrintWriter(string);
        for (ReebGraphVertex reebGraphVertex : arrayList2) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraphVertex.getPartner();
            if (reebGraphVertex2 != null && reebGraphVertex.value() > reebGraphVertex2.value()) continue;
            printWriter.println(reebGraphVertex.getBirth() + " " + reebGraphVertex.getDeath());
        }
        printWriter.close();
    }

    public static void printPersistentDiagram(ArrayList<ReebGraph> arrayList) {
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList2.addAll(object);
        }
        arrayList2.sort(new Comparator<ReebGraphVertex>(){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.getBirth() < reebGraphVertex2.getBirth()) {
                    return -1;
                }
                if (reebGraphVertex.getBirth() > reebGraphVertex2.getBirth()) {
                    return 1;
                }
                if (reebGraphVertex.getDeath() < reebGraphVertex2.getDeath()) {
                    return -1;
                }
                if (reebGraphVertex.getDeath() > reebGraphVertex2.getDeath()) {
                    return 1;
                }
                return 0;
            }
        });
        for (ReebGraphVertex reebGraphVertex : arrayList2) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraphVertex.getPartner();
            if (reebGraphVertex2 == null) {
                System.out.println("  [" + reebGraphVertex.getRealValue() + ",INF) " + reebGraphVertex.getGlobalID() + "/-1");
                continue;
            }
            if (reebGraphVertex.value() > reebGraphVertex2.value()) continue;
            System.out.println("  [" + reebGraphVertex.getRealValue() + "," + reebGraphVertex2.getRealValue() + ") " + reebGraphVertex.getGlobalID() + "/" + reebGraphVertex2.getGlobalID());
        }
    }

    public static String[] getPersistentDiagramCSV(ArrayList<ReebGraph> arrayList) {
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object2 : arrayList) {
            arrayList2.addAll(object2);
        }
        arrayList2.sort(new Comparator<ReebGraphVertex>(){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.getBirth() < reebGraphVertex2.getBirth()) {
                    return -1;
                }
                if (reebGraphVertex.getBirth() > reebGraphVertex2.getBirth()) {
                    return 1;
                }
                if (reebGraphVertex.getDeath() < reebGraphVertex2.getDeath()) {
                    return -1;
                }
                if (reebGraphVertex.getDeath() > reebGraphVertex2.getDeath()) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList arrayList3 = new ArrayList();
        String string = "birth_value,death_value,birth_index,death_index";
        System.out.println(string);
        arrayList3.add(string);
        for (ReebGraphVertex i : arrayList2) {
            String string2;
            ReebGraphVertex reebGraphVertex = (ReebGraphVertex)i.getPartner();
            if (reebGraphVertex == null) {
                string2 = i.getRealValue() + ",INF," + i.getGlobalID() + ",-1";
            } else {
                if (i.value() > reebGraphVertex.value()) continue;
                string2 = i.getRealValue() + "," + reebGraphVertex.getRealValue() + "," + i.getGlobalID() + "," + reebGraphVertex.getGlobalID();
            }
            System.out.println(string2);
            arrayList3.add(string2);
        }
        String[] stringArray = new String[arrayList3.size()];
        for (int i = 0; i < arrayList3.size(); ++i) {
            stringArray[i] = (String)arrayList3.get(i);
        }
        return stringArray;
    }

    public static ResultList getResultList(ArrayList<ReebGraph> arrayList) {
        ResultList resultList = new ResultList();
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList2.addAll(object);
        }
        arrayList2.sort(new Comparator<ReebGraphVertex>(){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.getBirth() < reebGraphVertex2.getBirth()) {
                    return -1;
                }
                if (reebGraphVertex.getBirth() > reebGraphVertex2.getBirth()) {
                    return 1;
                }
                return Float.compare(reebGraphVertex.getDeath(), reebGraphVertex2.getDeath());
            }
        });
        for (ReebGraphVertex reebGraphVertex : arrayList2) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraphVertex.getPartner();
            if (reebGraphVertex2 == null) {
                resultList.pTypes.add("NULL");
                resultList.vTypes.add(reebGraphVertex.getType().name());
                resultList.pValues.add(Float.valueOf(-1.0f));
                resultList.vValues.add(Float.valueOf(-1.0f));
                resultList.pRealValues.add(Float.valueOf(-1.0f));
                resultList.vRealValues.add(Float.valueOf(-1.0f));
                resultList.vGlobalIDs.add(reebGraphVertex.getGlobalID());
                continue;
            }
            if (reebGraphVertex.value() > reebGraphVertex2.value()) continue;
            resultList.pTypes.add(reebGraphVertex2.getType().name());
            resultList.vTypes.add(reebGraphVertex.getType().name());
            resultList.pValues.add(Float.valueOf(reebGraphVertex2.value()));
            resultList.vValues.add(Float.valueOf(reebGraphVertex.value()));
            resultList.pRealValues.add(Float.valueOf(reebGraphVertex2.getRealValue()));
            resultList.vRealValues.add(Float.valueOf(reebGraphVertex.getRealValue()));
            resultList.pGlobalIDs.add(reebGraphVertex2.getGlobalID());
            resultList.vGlobalIDs.add(reebGraphVertex.getGlobalID());
        }
        return resultList;
    }

    public static void printPersistentDiagramCSV(ArrayList<ReebGraph> arrayList) {
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList2.addAll(object);
        }
        arrayList2.sort(new Comparator<ReebGraphVertex>(){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.getBirth() < reebGraphVertex2.getBirth()) {
                    return -1;
                }
                if (reebGraphVertex.getBirth() > reebGraphVertex2.getBirth()) {
                    return 1;
                }
                if (reebGraphVertex.getDeath() < reebGraphVertex2.getDeath()) {
                    return -1;
                }
                if (reebGraphVertex.getDeath() > reebGraphVertex2.getDeath()) {
                    return 1;
                }
                return 0;
            }
        });
        System.out.println("birth_value,death_value,birth_index,death_index");
        for (ReebGraphVertex reebGraphVertex : arrayList2) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraphVertex.getPartner();
            if (reebGraphVertex2 == null) {
                System.out.println(reebGraphVertex.getRealValue() + ",INF," + reebGraphVertex.getGlobalID() + ",-1");
                continue;
            }
            if (reebGraphVertex.value() > reebGraphVertex2.value()) continue;
            System.out.println(reebGraphVertex.getRealValue() + "," + reebGraphVertex2.getRealValue() + "," + reebGraphVertex.getGlobalID() + "," + reebGraphVertex2.getGlobalID());
        }
    }

    public static boolean compareDiagrams(ArrayList<ReebGraph> arrayList, ArrayList<ReebGraph> arrayList2, boolean bl) {
        ArrayList<ReebGraphVertex> arrayList3 = new ArrayList<ReebGraphVertex>();
        ArrayList<ReebGraphVertex> arrayList4 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList3.addAll(object);
        }
        for (ReebGraph reebGraph : arrayList2) {
            arrayList4.addAll(reebGraph);
        }
        arrayList3.sort(new Comparator<ReebGraphVertex>(){

            @Override
            public int compare(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2) {
                if (reebGraphVertex.getBirth() < reebGraphVertex2.getBirth()) {
                    return -1;
                }
                if (reebGraphVertex.getBirth() > reebGraphVertex2.getBirth()) {
                    return 1;
                }
                if (reebGraphVertex.getDeath() < reebGraphVertex2.getDeath()) {
                    return -1;
                }
                if (reebGraphVertex.getDeath() > reebGraphVertex2.getDeath()) {
                    return 1;
                }
                return 0;
            }
        });
        boolean bl2 = true;
        for (ReebGraphVertex reebGraphVertex : arrayList3) {
            ReebGraphVertex reebGraphVertex2 = (ReebGraphVertex)reebGraphVertex.getPartner();
            if (reebGraphVertex2 == null) {
                System.out.println("  error == " + reebGraphVertex + " | NULL");
                bl2 = false;
                continue;
            }
            if (reebGraphVertex.value() > reebGraphVertex2.value()) continue;
            boolean bl3 = false;
            for (ReebGraphVertex reebGraphVertex3 : arrayList4) {
                bl3 = reebGraphVertex.getGlobalID() == reebGraphVertex3.getGlobalID() && ((ReebGraphVertex)reebGraphVertex.getPartner()).getGlobalID() == ((ReebGraphVertex)reebGraphVertex3.getPartner()).getGlobalID();
                if (!bl3) continue;
                break;
            }
            if (!bl3) {
                System.out.println("  error == " + reebGraphVertex + " | " + reebGraphVertex.getPartner());
            }
            bl2 = bl2 && bl3;
        }
        return bl2;
    }

    public static ArrayList<ReebGraph> runAlgo(String string, Pairing pairing, Timer timer, boolean bl) throws Exception {
        TimerMillisecond timerMillisecond = new TimerMillisecond();
        if (bl) {
            System.out.println();
        }
        if (bl) {
            System.out.println(pairing.getName());
        }
        timerMillisecond.start();
        ArrayList<ReebGraph> arrayList = ReebGraphLoader.load(string, true, true, bl);
        timerMillisecond.end();
        if (bl) {
            System.out.println(" Load time: " + timerMillisecond.getElapsedMilliseconds() + "ms");
        }
        if (bl) {
            System.out.println(" Connected components: " + arrayList.size());
        }
        timer.start();
        for (ReebGraph reebGraph : arrayList) {
            pairing.pair(reebGraph);
        }
        timer.end();
        if (bl) {
            System.out.println(" Total Loops: " + TestResults.countLoops(arrayList));
        }
        if (bl) {
            System.out.println(" " + pairing.getName() + " computation time: " + timer.getElapsedMilliseconds() + "ms\n");
        }
        if (bl) {
            System.out.println(" PERSISTENCE DIAGRAM");
        }
        return arrayList;
    }

    public static PairingResult runAlgo(int[] nArray, float[] fArray, int[] nArray2, int[] nArray3, Pairing pairing, Timer timer, boolean bl) throws Exception {
        TimerMillisecond timerMillisecond = new TimerMillisecond();
        if (bl) {
            System.out.println();
        }
        if (bl) {
            System.out.println(pairing.getName());
        }
        MergePairingInput mergePairingInput = new MergePairingInput(nArray, fArray, nArray2, nArray3);
        ArrayList<ReebGraph> arrayList = ReebGraphLoader.load(mergePairingInput, true, true, bl);
        if (bl) {
            System.out.println(" Connected components: " + arrayList.size());
        }
        timer.start();
        for (ReebGraph reebGraph : arrayList) {
            pairing.pair(reebGraph);
        }
        timer.end();
        PairingResult pairingResult = new PairingResult(arrayList, timer.getElapsedMilliseconds());
        if (bl) {
            System.out.println(" Total Loops: " + TestResults.countLoops(arrayList));
        }
        if (bl) {
            System.out.println(" " + pairing.getName() + " computation time: " + timer.getElapsedMilliseconds() + "ms\n");
        }
        if (bl) {
            System.out.println(" PERSISTENCE DIAGRAM");
        }
        return pairingResult;
    }

    private static int countLoops(ArrayList<ReebGraph> arrayList) {
        ArrayList<ReebGraphVertex> arrayList2 = new ArrayList<ReebGraphVertex>();
        for (ReebGraph object : arrayList) {
            arrayList2.addAll(object);
        }
        int n = 0;
        for (ReebGraphVertex reebGraphVertex : arrayList2) {
            if (!reebGraphVertex.isEssential() || reebGraphVertex.getType() != TopoTreeNode.NodeType.DOWNFORK) continue;
            ++n;
        }
        return n;
    }
}

