/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.reebgraph.pairing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import usf.saav.topology.TopoGraph;
import usf.saav.topology.TopoTreeNode;
import usf.saav.topology.reebgraph.ReebGraph;
import usf.saav.topology.reebgraph.ReebGraphVertex;
import usf.saav.topology.reebgraph.pairing.Pairing;

public class PropagateAndPair
implements Pairing {
    HashMap<ReebGraphVertex, TreeSet<Label>> inLabels;
    TreeSet<VEdge> virtEdges;

    @Override
    public String getName() {
        return "Pair and Propagate";
    }

    @Override
    public void pair(ReebGraph reebGraph) {
        this.inLabels = new HashMap();
        this.virtEdges = new TreeSet();
        for (TopoGraph.Vertex vertex : reebGraph) {
            this.inLabels.put((ReebGraphVertex)vertex, new TreeSet());
        }
        block7: for (ReebGraphVertex reebGraphVertex : reebGraph.getNodesSortedByValue()) {
            switch (reebGraphVertex.getType()) {
                case LEAF_MAX: {
                    this.processMax(reebGraphVertex);
                    continue block7;
                }
                case DOWNFORK: {
                    this.processMerge(reebGraphVertex);
                    continue block7;
                }
                case LEAF_MIN: {
                    this.processMin(reebGraphVertex);
                    continue block7;
                }
                case UPFORK: {
                    this.processSplit(reebGraphVertex);
                    continue block7;
                }
            }
            System.err.println("Unknown Critical Point Type");
        }
    }

    private void processMax(ReebGraphVertex reebGraphVertex) {
        ReebGraphVertex reebGraphVertex2 = null;
        ReebGraphVertex reebGraphVertex3 = null;
        for (Label label : this.inLabels.get(reebGraphVertex)) {
            if (label.isPaired()) continue;
            ReebGraphVertex reebGraphVertex4 = label.vrt;
            if (label.getType() == TopoTreeNode.NodeType.UPFORK && (reebGraphVertex2 == null || reebGraphVertex4.value() > reebGraphVertex2.value())) {
                reebGraphVertex2 = reebGraphVertex4;
            }
            if (label.getType() != TopoTreeNode.NodeType.LEAF_MIN || reebGraphVertex3 != null && !(reebGraphVertex3.value() > reebGraphVertex4.value())) continue;
            reebGraphVertex3 = reebGraphVertex4;
        }
        while (!this.virtEdges.isEmpty() && this.virtEdges.first().n0 == reebGraphVertex) {
            this.virtEdges.pollFirst();
        }
        if (reebGraphVertex2 != null) {
            reebGraphVertex.setPartner(reebGraphVertex2);
            reebGraphVertex2.setPartner(reebGraphVertex);
        } else {
            reebGraphVertex.setPartner(reebGraphVertex3);
            reebGraphVertex3.setPartner(reebGraphVertex);
        }
    }

    private void processSplit(ReebGraphVertex reebGraphVertex) {
        ReebGraphVertex reebGraphVertex2 = null;
        ReebGraphVertex reebGraphVertex3 = null;
        for (ReebGraphVertex reebGraphVertex4 : reebGraphVertex.neighbors) {
            if (!(reebGraphVertex4.value() > reebGraphVertex.value())) continue;
            if (reebGraphVertex2 == null) {
                reebGraphVertex2 = reebGraphVertex4;
                continue;
            }
            reebGraphVertex3 = reebGraphVertex4;
        }
        this.inLabels.get(reebGraphVertex2).add(new Label(reebGraphVertex, 1));
        this.inLabels.get(reebGraphVertex3).add(new Label(reebGraphVertex, 2));
        this.inLabels.get(reebGraphVertex2).addAll((Collection<Label>)this.inLabels.get(reebGraphVertex));
        this.inLabels.get(reebGraphVertex3).addAll((Collection<Label>)this.inLabels.get(reebGraphVertex));
        this.virtEdges.add(new VEdge(reebGraphVertex, reebGraphVertex2, reebGraphVertex3));
        while (!this.virtEdges.isEmpty() && this.virtEdges.first().n0 == reebGraphVertex) {
            VEdge vEdge = this.virtEdges.pollFirst();
            if (vEdge.gen.getPartner() != null) continue;
            this.virtEdges.add(new VEdge(vEdge.gen, reebGraphVertex2, vEdge.n1));
            this.virtEdges.add(new VEdge(vEdge.gen, reebGraphVertex3, vEdge.n1));
        }
    }

    private void processMin(ReebGraphVertex reebGraphVertex) {
        for (ReebGraphVertex reebGraphVertex2 : reebGraphVertex.neighbors) {
            this.inLabels.get(reebGraphVertex2).add(new Label(reebGraphVertex, 0));
        }
    }

    private void processMerge(ReebGraphVertex reebGraphVertex) {
        ReebGraphVertex reebGraphVertex222;
        ReebGraphVertex reebGraphVertex3 = null;
        for (ReebGraphVertex reebGraphVertex222 : reebGraphVertex.neighbors) {
            if (!(reebGraphVertex222.value() > reebGraphVertex.value())) continue;
            reebGraphVertex3 = reebGraphVertex222;
        }
        Object object = null;
        reebGraphVertex222 = null;
        Label label = null;
        for (Comparable<Label> comparable2 : this.inLabels.get(reebGraphVertex)) {
            if (comparable2.isPaired()) continue;
            if (comparable2.getType() == TopoTreeNode.NodeType.LEAF_MIN) {
                object = comparable2.vrt;
            } else if (comparable2.getType() == TopoTreeNode.NodeType.UPFORK && label != null && comparable2.vrt == label.vrt) {
                reebGraphVertex222 = comparable2.vrt;
            }
            label = comparable2;
        }
        if (reebGraphVertex222 != null) {
            reebGraphVertex.setPartner(reebGraphVertex222);
            reebGraphVertex222.setPartner(reebGraphVertex);
        } else {
            reebGraphVertex.setPartner((ReebGraphVertex)object);
            ((ReebGraphVertex)object).setPartner(reebGraphVertex);
        }
        ArrayList arrayList = new ArrayList();
        while (!this.virtEdges.isEmpty() && this.virtEdges.first().n0 == reebGraphVertex) {
            Comparable<Label> comparable2;
            comparable2 = this.virtEdges.pollFirst();
            if (((VEdge)comparable2).gen.getPartner() != null || ((VEdge)comparable2).n1 == reebGraphVertex || !this.virtEdges.isEmpty() && this.virtEdges.first().n0 == reebGraphVertex && this.virtEdges.first().n1 == ((VEdge)comparable2).n1) continue;
            this.virtEdges.add(new VEdge(((VEdge)comparable2).gen, reebGraphVertex3, ((VEdge)comparable2).n1));
            arrayList.add(comparable2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            VEdge comparable4 = (VEdge)arrayList.get(i);
            for (int j = i + 1; j < arrayList.size(); ++j) {
                VEdge vEdge = (VEdge)arrayList.get(j);
                if (comparable4.gen.value() < vEdge.gen.value()) {
                    this.virtEdges.add(new VEdge(comparable4.gen, comparable4.n1, vEdge.n1));
                }
                if (!(vEdge.gen.value() < comparable4.gen.value())) continue;
                this.virtEdges.add(new VEdge(vEdge.gen, vEdge.n1, comparable4.n1));
            }
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            VEdge vEdge = (VEdge)iterator.next();
            for (Label label2 : this.inLabels.get(reebGraphVertex)) {
                if (label2.isPaired() || !(label2.vrt.value() < vEdge.gen.value())) continue;
                this.inLabels.get(vEdge.n1).add(label2);
            }
        }
        for (Label label3 : this.inLabels.get(reebGraphVertex)) {
            if (label3.isPaired()) continue;
            this.inLabels.get(reebGraphVertex3).add(label3);
        }
    }

    private class VEdge
    implements Comparable<VEdge> {
        ReebGraphVertex n0;
        ReebGraphVertex n1;
        ReebGraphVertex gen;

        public VEdge(ReebGraphVertex reebGraphVertex, ReebGraphVertex reebGraphVertex2, ReebGraphVertex reebGraphVertex3) {
            this.gen = reebGraphVertex;
            this.n0 = reebGraphVertex2.value() < reebGraphVertex3.value() ? reebGraphVertex2 : reebGraphVertex3;
            this.n1 = reebGraphVertex2.value() < reebGraphVertex3.value() ? reebGraphVertex3 : reebGraphVertex2;
        }

        @Override
        public int compareTo(VEdge vEdge) {
            if (this.n0.value() < vEdge.n0.value()) {
                return -1;
            }
            if (this.n0.value() > vEdge.n0.value()) {
                return 1;
            }
            if (this.n1.value() < vEdge.n1.value()) {
                return -1;
            }
            if (this.n1.value() > vEdge.n1.value()) {
                return 1;
            }
            if (this.gen.value() < vEdge.gen.value()) {
                return -1;
            }
            if (this.gen.value() > vEdge.gen.value()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.n0.getGlobalID() + "(" + this.n0.value() + ") ==> " + this.gen.getGlobalID() + " " + this.n1.getGlobalID() + "(" + this.n1.value() + ") ==> " + this.gen.getGlobalID();
        }
    }

    private class Label
    implements Comparable<Label> {
        ReebGraphVertex vrt;
        int leg;

        Label(ReebGraphVertex reebGraphVertex, int n) {
            this.vrt = reebGraphVertex;
            this.leg = n;
        }

        public boolean isPaired() {
            return this.vrt.getPartner() != null;
        }

        public int hashCode() {
            return this.vrt.hashCode() * (this.leg + 13);
        }

        public TopoTreeNode.NodeType getType() {
            return this.vrt.getType();
        }

        public boolean equals(Object object) {
            if (object instanceof Label) {
                Label label = (Label)object;
                return label.vrt == this.vrt && label.leg == this.leg;
            }
            return false;
        }

        public String toString() {
            return this.vrt.getGlobalID() + "[" + this.leg + "]";
        }

        @Override
        public int compareTo(Label label) {
            if (this.vrt.value() < label.vrt.value()) {
                return -1;
            }
            if (this.vrt.value() > label.vrt.value()) {
                return 1;
            }
            if (this.leg < label.leg) {
                return -1;
            }
            if (this.leg > label.leg) {
                return 1;
            }
            return 0;
        }
    }
}

