/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.highprecision;

import java.io.Serializable;

public class LegacyDoubleDouble
implements Serializable,
Comparable<LegacyDoubleDouble>,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final LegacyDoubleDouble PI = new LegacyDoubleDouble(Math.PI, 1.2246467991473532E-16);
    public static final LegacyDoubleDouble TWO_PI = new LegacyDoubleDouble(Math.PI * 2, 2.4492935982947064E-16);
    public static final LegacyDoubleDouble PI_2 = new LegacyDoubleDouble(1.5707963267948966, 6.123233995736766E-17);
    public static final LegacyDoubleDouble E = new LegacyDoubleDouble(Math.E, 1.4456468917292502E-16);
    public static final LegacyDoubleDouble NaN = new LegacyDoubleDouble(Double.NaN, Double.NaN);
    public static final double EPS = 1.23259516440783E-32;
    private static final double SPLIT = 1.34217729E8;
    private static final int MAX_PRINT_DIGITS = 32;
    private static final LegacyDoubleDouble TEN = new LegacyDoubleDouble(10.0);
    private static final LegacyDoubleDouble ONE = new LegacyDoubleDouble(1.0);
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    private static final String SCI_NOT_ZERO = "0.0E0";
    private double high = 0.0;
    private double low = 0.0;

    public static LegacyDoubleDouble parse(String str) throws NumberFormatException {
        char signCh;
        int i = 0;
        int strlen = str.length();
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        boolean isNegative = false;
        if (i < strlen && ((signCh = str.charAt(i)) == '-' || signCh == '+')) {
            ++i;
            if (signCh == '-') {
                isNegative = true;
            }
        }
        LegacyDoubleDouble val = new LegacyDoubleDouble();
        int numDigits = 0;
        int numBeforeDec = 0;
        int exp = 0;
        while (i < strlen) {
            char ch = str.charAt(i);
            ++i;
            if (Character.isDigit(ch)) {
                double d = ch - 48;
                val.selfMultiply(TEN);
                val.selfAdd(new LegacyDoubleDouble(d));
                ++numDigits;
                continue;
            }
            if (ch == '.') {
                numBeforeDec = numDigits;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                String expStr = str.substring(i);
                try {
                    exp = Integer.parseInt(expStr);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                }
            }
            throw new NumberFormatException("Unexpected character '" + ch + "' at position " + i + " in string " + str);
        }
        LegacyDoubleDouble val2 = val;
        int numDecPlaces = numDigits - numBeforeDec - exp;
        if (numDecPlaces == 0) {
            val2 = val;
        } else if (numDecPlaces > 0) {
            LegacyDoubleDouble scale = TEN.pow(numDecPlaces);
            val2 = val.divide(scale);
        } else if (numDecPlaces < 0) {
            LegacyDoubleDouble scale = TEN.pow(-numDecPlaces);
            val2 = val.multiply(scale);
        }
        if (isNegative) {
            return val2.negate();
        }
        return val2;
    }

    public static LegacyDoubleDouble valueOf(double x) {
        return new LegacyDoubleDouble(x);
    }

    public static LegacyDoubleDouble valueOf(String str) throws NumberFormatException {
        return LegacyDoubleDouble.parse(str);
    }

    private static int magnitude(double x) {
        double xAbs = Math.abs(x);
        double xLog10 = Math.log(xAbs) / Math.log(10.0);
        int xMag = (int)Math.floor(xLog10);
        double xApprox = Math.pow(10.0, xMag);
        if (xApprox * 10.0 <= xAbs) {
            ++xMag;
        }
        return xMag;
    }

    private static String stringOfChar(char ch, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public LegacyDoubleDouble() {
        this.init(0.0);
    }

    public LegacyDoubleDouble(double x) {
        this.init(x);
    }

    public LegacyDoubleDouble(double hi, double lo) {
        this.init(hi, lo);
    }

    public LegacyDoubleDouble(LegacyDoubleDouble dd) {
        this.init(dd);
    }

    public LegacyDoubleDouble(String str) throws NumberFormatException {
        this(LegacyDoubleDouble.parse(str));
    }

    public LegacyDoubleDouble abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isNegative()) {
            return this.negate();
        }
        return new LegacyDoubleDouble(this);
    }

    public LegacyDoubleDouble add(LegacyDoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        return new LegacyDoubleDouble(this).selfAdd(y);
    }

    public LegacyDoubleDouble ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.ceil(this.high);
        double flo = 0.0;
        if (fhi == this.high) {
            flo = Math.ceil(this.low);
        }
        return new LegacyDoubleDouble(fhi, flo);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public int compareTo(LegacyDoubleDouble other) {
        if (this.high < other.high) {
            return -1;
        }
        if (this.high > other.high) {
            return 1;
        }
        if (this.low < other.low) {
            return -1;
        }
        if (this.low > other.low) {
            return 1;
        }
        return 0;
    }

    public LegacyDoubleDouble divide(LegacyDoubleDouble y) {
        double C = this.high / y.high;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * y.high;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - y.high;
        double U = C * y.high;
        hy = u - hy;
        double ty = y.high - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.high - U - u + this.low - C * y.low) / y.high;
        double zhi = u = C + c;
        double zlo = C - u + c;
        return new LegacyDoubleDouble(zhi, zlo);
    }

    public double doubleValue() {
        return this.high + this.low;
    }

    public String dump() {
        return "DD<" + this.high + ", " + this.low + ">";
    }

    public boolean equals(LegacyDoubleDouble y) {
        return this.high == y.high && this.low == y.low;
    }

    public LegacyDoubleDouble floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.floor(this.high);
        double flo = 0.0;
        if (fhi == this.high) {
            flo = Math.floor(this.low);
        }
        return new LegacyDoubleDouble(fhi, flo);
    }

    public boolean ge(LegacyDoubleDouble y) {
        return this.high > y.high || this.high == y.high && this.low >= y.low;
    }

    public boolean gt(LegacyDoubleDouble y) {
        return this.high > y.high || this.high == y.high && this.low > y.low;
    }

    public int intValue() {
        return (int)this.high;
    }

    public boolean isNaN() {
        return Double.isNaN(this.high);
    }

    public boolean isNegative() {
        return this.high < 0.0 || this.high == 0.0 && this.low < 0.0;
    }

    public boolean isPositive() {
        return this.high > 0.0 || this.high == 0.0 && this.low > 0.0;
    }

    public boolean isZero() {
        return this.high == 0.0 && this.low == 0.0;
    }

    public boolean le(LegacyDoubleDouble y) {
        return this.high < y.high || this.high == y.high && this.low <= y.low;
    }

    public boolean lt(LegacyDoubleDouble y) {
        return this.high < y.high || this.high == y.high && this.low < y.low;
    }

    public LegacyDoubleDouble multiply(LegacyDoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        if (y.isNaN()) {
            return y;
        }
        return new LegacyDoubleDouble(this).selfMultiply(y);
    }

    public LegacyDoubleDouble negate() {
        if (this.isNaN()) {
            return this;
        }
        return new LegacyDoubleDouble(-this.high, -this.low);
    }

    public LegacyDoubleDouble pow(int exp) {
        if ((double)exp == 0.0) {
            return LegacyDoubleDouble.valueOf(1.0);
        }
        LegacyDoubleDouble r = new LegacyDoubleDouble(this);
        LegacyDoubleDouble s = LegacyDoubleDouble.valueOf(1.0);
        int n = Math.abs(exp);
        if (n > 1) {
            while (n > 0) {
                if (n % 2 == 1) {
                    s.selfMultiply(r);
                }
                if ((n /= 2) <= 0) continue;
                r = r.sqr();
            }
        } else {
            s = r;
        }
        if (exp < 0) {
            return s.reciprocal();
        }
        return s;
    }

    public LegacyDoubleDouble reciprocal() {
        double C = 1.0 / this.high;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * this.high;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - this.high;
        double U = C * this.high;
        hy = u - hy;
        double ty = this.high - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (1.0 - U - u - C * this.low) / this.high;
        double zhi = C + c;
        double zlo = C - zhi + c;
        return new LegacyDoubleDouble(zhi, zlo);
    }

    public LegacyDoubleDouble rint() {
        if (this.isNaN()) {
            return this;
        }
        LegacyDoubleDouble plus5 = this.add(new LegacyDoubleDouble(0.5));
        return plus5.floor();
    }

    public int signum() {
        if (this.isPositive()) {
            return 1;
        }
        if (this.isNegative()) {
            return -1;
        }
        return 0;
    }

    public LegacyDoubleDouble sqr() {
        return this.multiply(this);
    }

    public LegacyDoubleDouble sqrt() {
        if (this.isZero()) {
            return new LegacyDoubleDouble(0.0);
        }
        if (this.isNegative()) {
            return NaN;
        }
        double x = 1.0 / Math.sqrt(this.high);
        double ax = this.high * x;
        LegacyDoubleDouble axdd = new LegacyDoubleDouble(ax);
        LegacyDoubleDouble diffSq = this.subtract(axdd.sqr());
        double d2 = diffSq.high * (x * 0.5);
        return axdd.add(new LegacyDoubleDouble(d2));
    }

    public LegacyDoubleDouble subtract(LegacyDoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        return this.add(y.negate());
    }

    public String toSciNotation() {
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (digits.charAt(0) == '0') {
            throw new IllegalStateException("Found leading zero: " + digits);
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            trailingDigits = digits.substring(1);
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        if (this.isNegative()) {
            return "-" + digitsWithDecimal + expStr;
        }
        return digitsWithDecimal + expStr;
    }

    public String toStandardNotation() {
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        Object num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + LegacyDoubleDouble.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (sigDigits.indexOf(46) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = LegacyDoubleDouble.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        if (this.isNegative()) {
            return "-" + (String)num;
        }
        return num;
    }

    public String toString() {
        int mag = LegacyDoubleDouble.magnitude(this.high);
        if (mag >= -3 && mag <= 20) {
            return this.toStandardNotation();
        }
        return this.toSciNotation();
    }

    public LegacyDoubleDouble trunc() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isPositive()) {
            return this.floor();
        }
        return this.ceil();
    }

    private String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        LegacyDoubleDouble y = this.abs();
        int mag = LegacyDoubleDouble.magnitude(y.high);
        LegacyDoubleDouble scale = TEN.pow(mag);
        if ((y = y.divide(scale)).gt(TEN)) {
            y = y.divide(TEN);
            ++mag;
        } else if (y.lt(ONE)) {
            y = y.multiply(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuilder buf = new StringBuilder();
        int numDigits = 31;
        for (int i = 0; i <= numDigits; ++i) {
            int digit;
            if (insertDecimalPoint && i == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y.high) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y = y.subtract(LegacyDoubleDouble.valueOf(digit)).multiply(TEN);
            if (rebiasBy10) {
                y.selfAdd(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = LegacyDoubleDouble.magnitude(y.high);
            if (remMag < 0 && Math.abs(remMag) >= numDigits - i) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits) break;
        }
        magnitude[0] = mag;
        return buf.toString();
    }

    private String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        if (this.isNaN()) {
            return "NaN ";
        }
        return null;
    }

    private void init(double x) {
        this.init(x, 0.0);
    }

    private void init(double hi, double lo) {
        this.high = hi;
        this.low = lo;
    }

    private void init(LegacyDoubleDouble dd) {
        this.init(dd.high, dd.low);
    }

    private LegacyDoubleDouble selfAdd(LegacyDoubleDouble y) {
        double S = this.high + y.high;
        double T2 = this.low + y.low;
        double e = S - this.high;
        double f = T2 - this.low;
        double s = S - e;
        double t = T2 - f;
        s = y.high - e + (this.high - s);
        t = y.low - f + (this.low - t);
        e = s + T2;
        double H = S + e;
        double h = e + (S - H);
        e = t + h;
        double zhi = H + e;
        double zlo = e + (H - zhi);
        this.high = zhi;
        this.low = zlo;
        return this;
    }

    private LegacyDoubleDouble selfMultiply(LegacyDoubleDouble y) {
        double C = 1.34217729E8 * this.high;
        double hx = C - this.high;
        double c = 1.34217729E8 * y.high;
        hx = C - hx;
        double tx = this.high - hx;
        double hy = c - y.high;
        C = this.high * y.high;
        hy = c - hy;
        double ty = y.high - hy;
        c = hx * hy - C + hx * ty + tx * hy + tx * ty + (this.high * y.low + this.low * y.high);
        double zhi = C + c;
        hx = C - zhi;
        double zlo = c + hx;
        this.high = zhi;
        this.low = zlo;
        return this;
    }
}

