/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenRoutines;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;

class SymmetricEigenSystem
implements IEigenSystem {
    private FastMatrix m_sm;
    private double[] m_ev;
    private FastMatrix m_eivec;
    private boolean m_bCalc;
    private double m_zero = 1.0E-9;
    private int m_maxiter = 100;
    private boolean m_bVec;

    public SymmetricEigenSystem() {
    }

    public SymmetricEigenSystem(FastMatrix m) {
        this.m_sm = m.deepClone();
    }

    @Override
    public void compute() {
        this.m_bCalc = false;
        this.calc();
    }

    void calc() {
        if (this.m_bCalc) {
            return;
        }
        EigenRoutines.setMaxIter(this.m_maxiter);
        double[] data = EigenSystem.convertToArray(this.m_sm);
        this.m_ev = EigenRoutines.householder(data, this.m_sm.getRowsCount(), this.m_bVec);
        EigenRoutines.triQL(this.m_ev, this.m_sm.getRowsCount(), data, this.m_bVec);
        this.m_eivec = new FastMatrix(data, this.m_sm.getRowsCount(), this.m_sm.getColumnsCount());
        this.m_bCalc = true;
    }

    @Override
    public Complex[] getEigenValues() {
        this.calc();
        int n = this.m_sm.getRowsCount();
        Complex[] rout = new Complex[n];
        for (int i = 0; i < rout.length; ++i) {
            rout[i] = Complex.cart((double)this.m_ev[n + i], (double)0.0);
        }
        return rout;
    }

    @Override
    public Complex[] getEigenValues(int m) {
        this.calc();
        int n = this.m_sm.getRowsCount();
        int mel = Math.min(n, m);
        Complex[] rout = new Complex[mel];
        for (int i = 0; i < mel; ++i) {
            rout[i] = Complex.cart((double)this.m_ev[n + i], (double)0.0);
        }
        return rout;
    }

    @Override
    public double[] getEigenVector(int idx) {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        return this.m_eivec.column(idx).toArray();
    }

    @Override
    public FastMatrix getEigenVectors() {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        FastMatrix iout = this.m_eivec.deepClone();
        return iout;
    }

    @Override
    public FastMatrix getEigenVectors(int m) {
        if (!this.m_bVec) {
            throw new MatrixException("eig_init");
        }
        this.calc();
        int n = this.m_eivec.getRowsCount();
        int mel = Math.min(m, this.m_eivec.getColumnsCount());
        FastMatrix sm = FastMatrix.make(n, mel);
        for (int i = 0; i < sm.getRowsCount(); ++i) {
            for (int j = 0; j < mel; ++j) {
                sm.set(i, j, this.m_eivec.get(i, j));
            }
        }
        return sm;
    }

    @Override
    public double getZero() {
        return this.m_zero;
    }

    @Override
    public void setZero(double value) {
        this.m_zero = value;
    }

    public int getMaxIter() {
        return this.m_maxiter;
    }

    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    @Override
    public boolean isComputingEigenVectors() {
        return this.m_bVec;
    }

    @Override
    public void setComputingEigenVectors(boolean value) {
        this.m_bVec = value;
        this.m_bCalc = false;
    }
}

