/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.sa.base.core.tests.SeasonalityTests;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.tests.NiidTests;

public class ModelVerifier {
    private static final double OUT = 0.03;
    private static final double NORMAL = 6.0;
    private static final double SKEWNESS = 2.576;
    private static final double RUNS = 2.576;
    private static final double QSTAT = 0.05;
    private static final double QS = 6.0;
    private static final double MEAN = 0.01;

    public boolean accept(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        RegArimaEstimation estimation = context.getEstimation();
        int nz = desc.getSeries().getValues().count(x -> Double.isFinite(x));
        if ((double)desc.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true)).count() > 0.03 * (double)nz) {
            return false;
        }
        int period = desc.getAnnualFrequency();
        NiidTests niid = NiidTests.builder().data(estimation.getConcentratedLikelihood().e()).period(period).k(RegArimaUtility.defaultLjungBoxLength((int)period)).ks(2).seasonal(period > 1).hyperParametersCount(estimation.parametersCount()).build();
        if (niid.normalityTest().getValue() > 6.0) {
            return false;
        }
        if (niid.ljungBox().getPvalue() < 0.05) {
            return false;
        }
        if (niid.skewness().getValue() > 2.576) {
            return false;
        }
        if (niid.runsNumber().getValue() > 2.576) {
            return false;
        }
        if (niid.meanTest().getPvalue() < 0.01) {
            return false;
        }
        if (period > 1) {
            if (niid.seasonalLjungBox().getValue() > 6.0) {
                return false;
            }
            DoubleSeq res = estimation.getConcentratedLikelihood().e();
            SeasonalityTests stests = SeasonalityTests.residualSeasonalityTest((DoubleSeq)res, (int)period);
            if (stests.getScore() > 1) {
                return false;
            }
        }
        return true;
    }
}

