## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

library(appraise)

## ----bias-priors--------------------------------------------------------------
bias_spec <- build_bias_specification(
  num_biases = 2,
  b_types = "Confounding",
  s_types = "Selection Bias",
  ab_params = list(Confounding = c(2, 5)),
  skn_params = list(`Selection Bias` = c(0, 0.2, 5))
)

if (requireNamespace("sn", quietly = TRUE)) {
  xi_samples <- simulate_bias_priors(bias_spec, n_draws = 2000)
} else {
  xi_samples <- NULL
  message("Package 'sn' not available; skipping skew-normal bias simulation.")
}

## ----posteriors---------------------------------------------------------------
set.seed(123)

# Mock posterior draws representing a study-level posterior
theta_draws <- rnorm(2000, mean = -0.5, sd = 0.15)

mid_draws <- theta_draws  # midpoint samples used downstream

## -----------------------------------------------------------------------------
posterior_probability(mid_draws)

## -----------------------------------------------------------------------------
theta_list <- list(
  theta_draws,
  rnorm(2000, -0.4, 0.2)
)

weights <- c(0.6, 0.4)

mix <- posterior_mixture(theta_list, weights)
mix$summary

